<?php
#Wr By @Code_Compile

ini_set('log_errors', 'Off');
ini_set('display_errors', 'On');
error_reporting(E_ALL); 
require_once 'jdf.php';
require_once 'Telegram.php';
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


date_default_timezone_set("asia/tehran");

$tokan      = "7825890024:AAEy6XVux5iFE-ty7IYv9GRIUU56wKKbeWs"; //token
$admins     = array(367225476,1960131873); //admin userid
$channelpay = '-1002345696416';
$EFI        = new Telegram($tokan);
$update     = $EFI->Update();
$date       = jdate("Y/m/d");
$domain     = dirname('https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
$updateType = $EFI->getUpdateType();
//-------db login info
$servername = 'localhost';
$username   = 'bazergan_bot';//db username
$password   = 'bazergan_bot';//db password
$dbname     = 'bazergan_bot';//db name
$connect    = mysqli_connect($servername,$username,$password, $dbname);
$connect->set_charset('utf8mb4_general_ci');
$connect->query('SET NAMES utf8mb4');

//-------telegram update's
@$from_id       = $EFI->UserID();
@$chat_id       = $EFI->ChatID();
@$message_id    = $EFI->MessageID();
@$text          = $EFI->Text();
@$username      = $EFI->Username();
@$firstname     = $EFI->FirstName();
@$forwardchatid = $EFI->FromChatID();
@$callbackid    = $EFI->CallbackQueryID();
@$voice_id      = $EFI->voiceid();
@$file_id       = $EFI->documentid();
@$caption       = $EFI->Caption();
@$audio_id      = $EFI->audioid();
@$sticker_id    = $EFI->stickerid();
@$video_id      = $EFI->videoid();
@$photo_id      = $EFI->photoid();
@$gif_id        = $EFI->gifid();
@$raplyt        = $EFI->ReplyToMessagetxt();
@$remsg         = $EFI->ReplyToMessageID();
@$data          = $EFI->Callback_Data();
@$tc            = $EFI->messageFromGroup();
@$rand          = $EFI->random();
@$botID         = $EFI->getMe()['result']['id'];
@$botUsername   = 'https://t.me/'.$EFI->getMe()['result']['username'];
@$botName       = 'بازرگانی راد';

//-------db's data
@$user          = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM `user` WHERE `id` = '$from_id' LIMIT 1"));
@$database      = mysqli_fetch_assoc(mysqli_query($connect,"SELECT * FROM `database` WHERE `id` = '$from_id' LIMIT 1"));


$Keyboard = [
    'Start'=>[
        'inline_keyboard' => [
            [['text' => 'راهنمای استفاده از ربات', 'callback_data' => 'help']],
        ]
    ],
    'BackPanel'=>[
        'inline_keyboard' => [
            [['text' => 'برگشت به پنل مدیریت', 'callback_data' => 'back_panel']],
        ]
    ],
    'Panel'=>[
        'inline_keyboard' => [
            [['text' => 'تعریف دوره', 'callback_data' => 'add_course'],['text' => 'حذف دوره', 'callback_data' => 'del_course']],
            [['text' => 'ویرایش دوره', 'callback_data' => 'edit_course']],
            
            [['text' => 'آپلود پوستر دوره ها', 'callback_data' => 'upload_course'],['text' => 'لیست دوره ها', 'callback_data' => 'courses']],
            [['text' => 'ثبت ویدیو اخر', 'callback_data' => 'set_video']],
            [['text' => 'تنظیمات بخش پرداخت', 'callback_data' => 'pay_settings']],
        ]
    ],
    'Pay'=>[
        'inline_keyboard' => [
            [['text' => 'تنظیم مرچنت آیدی', 'callback_data' => 'set_merchent'],['text' => 'تنظیم نوع درگاه', 'callback_data' => 'set_type']],
            [['text' => 'تنظیم شماره کارت', 'callback_data' => 'set_card'],['text' => 'تنظیم نام شماره کارت', 'callback_data' => 'set_cardname']],
            [['text' => 'تنظیمات مربوط به پرداخت اقساط', 'callback_data' => 'set_installment']],
            [['text' => 'برگشت به پنل مدیریت', 'callback_data' => 'back_panel']],
        ]
    ],
];

function getRoomlink($day,$monthNumber,$year) {
    $months = [
        '01' => 'farvardin',
        '02' => 'ordibehesht',
        '03' => 'khordad',
        '04' => 'tir',
        '05' => 'mordad',
        '06' => 'shahrivar',
        '07' => 'mehr',
        '08' => 'aban',
        '09' => 'azar',
        '10' => 'dey',
        '11' => 'bahman',
        '12' => 'esfand'
    ];
    $monthNumber = str_pad($monthNumber, 2, '0', STR_PAD_LEFT);

    if (isset($months[$monthNumber])) {
        return "radgroup-$day-{$months[$monthNumber]}-$year";
    } else {
        return 'error!';
    }
}


function exportSqlToExcel($sqlQuery, $filename = 'export.xlsx') {
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    $pdo = new PDO(
        "mysql:host=localhost;dbname=bazergan_bot;charset=utf8mb4",
        "bazergan_bot",
        "bazergan_bot",
        [
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES 'utf8mb4'",
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ]
    );

    $statement = $pdo->query($sqlQuery);
    $data = $statement->fetchAll(PDO::FETCH_ASSOC);

    if (empty($data)) {
        throw new Exception("No data found for the provided SQL query.");
    }

    $column = 1;
    foreach (array_keys($data[0]) as $fieldName) {
        $sheet->setCellValueByColumnAndRow($column++, 1, $fieldName);
    }

    $row = 2;
    foreach ($data as $rowData) {
        $column = 1;
        foreach ($rowData as $value) {
            $sheet->setCellValueByColumnAndRow($column++, $row, $value);
        }
        $row++;
    }

    $writer = new Xlsx($spreadsheet);
    $writer->save($filename);

    return $filename;
}

function shamsiToMiladi($shamsiDateTime) {
    $parts = explode(",", $shamsiDateTime);
    $date = $parts[0];
    $time = isset($parts[1]) ? $parts[1] : "00:00:00";

    list($jy, $jm, $jd) = explode("/", str_replace("-", "/", $date));
    list($gy, $gm, $gd) = jalali_to_gregorian($jy, $jm, $jd);

    return strtotime("$gy-$gm-$gd $time");
}

function processExcel(string $filePath): array {
    $spreadsheet = IOFactory::load($filePath);
    $tables = [];
    foreach ($spreadsheet->getAllSheets() as $sheet) {
        $data = $sheet->toArray();
        $headers = array_shift($data); 
        foreach ($headers as $header) {
            if (!empty($header)) { 
                $tables[$header] = [];
            }
        }
        foreach ($data as $row) {
            foreach ($headers as $index => $header) {
                if (!empty($header)) {
                    $tables[$header][] = $row[$index]; 
                }
            }
        }
    }
    return $tables;
}

function saveToDb(array $tables): void {
    $pdo = new PDO('mysql:host=localhost;dbname=bazergan_bot', 'bazergan_bot', 'bazergan_bot');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    foreach ($tables as $tableName => $values) {
        try {
            $pdo->exec("CREATE TABLE IF NOT EXISTS `$tableName` ( `national_code` VARCHAR(20) NOT NULL)");
        } catch (PDOException $e) {
            error_log("Error creating table $tableName: " . $e->getMessage());
            continue;
        }

        foreach ($values as $value) {
            $value = preg_replace('/^\s+|\s+$/u', '', $value);
            if (!empty($value)) {
                $stmt = $pdo->prepare("INSERT INTO `$tableName` (`national_code`) VALUES (:national_code)");
                $stmt->execute(['national_code' => $value]);
            }
        }
    }
}


function Code($length = 5) {
    $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    $charactersLength = strlen($characters);
    $randomCode = '';
    for ($i = 0; $i < $length; $i++) {
        $randomCode .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomCode;
}

function generateInlineKeyboardFromDB($mysqli, $tableName, $titleField, $dataField, $prefixField = null) {
    $keyboard = [];
    
    $query = "SELECT `$titleField`, `$dataField` FROM `$tableName`";
    $result = $mysqli->query($query);

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $keyboard[] = [
                [
                    'text' => $row[$titleField],
                    'callback_data' => $prefixField.$row[$dataField]
                ]
            ];
        }
        $keyboard[] = [['text' => 'برگشت به پنل مدیریت', 'callback_data' => 'back_panel']];
        return json_encode([
            'inline_keyboard' => $keyboard
        ]);
    } else {
        return false;
    }
}

function getTable($mysqli, $selectField, $tableName) {
    $query = "SELECT `$selectField` FROM `$tableName`";
    $result = $mysqli->query($query);

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        return $row[$selectField];
    } else {
        return false;
    }
}


function generateInvoiceCode($prefix = "INV", $length = 8) {
    $randomPart = strtoupper(substr(md5(uniqid(mt_rand(), true)), 0, $length));
    return $prefix . "." . $randomPart;
}

function applyDiscount($price, $discount, $isPercentage = true) {
    if ($isPercentage) {
        $discountAmount = ($price * $discount) / 100;
    } else {
        $discountAmount = $discount;
    }

    $finalPrice = $price - $discountAmount;

    return [
        'original_price' => $price,
        'discount_amount' => round($discountAmount, 2),
        'final_price' => round($finalPrice, 2)
    ];
}

